float4x4 WorldViewProjection : WORLDVIEWPROJECTION;
float4 Kolor : COLOR = float4(1.0,1.0,1.0,1.0);
bool KopiujKolorWerteksu = false;
float amplituda = 0.1;
float okres = 0.01;
float faza = 0;

struct VertexShaderInput
{
	float4 Kolor : COLOR0;
	float4 Pozycja : POSITION0;

	float3 KopiaPozycji : TEXCOORD0;
};

VertexShaderInput VS(VertexShaderInput input)
{
	float kat=faza/10;

	float2x2 macierzObrotu;
	macierzObrotu[0][0]=cos(kat);
	macierzObrotu[1][1]=macierzObrotu[0][0];
	macierzObrotu[1][0]=sin(kat);
	macierzObrotu[0][1]=-macierzObrotu[1][0];
	input.Pozycja.xy=mul(input.Pozycja.xy,macierzObrotu);


	VertexShaderInput output;	
	output.Pozycja=mul(input.Pozycja,WorldViewProjection);
	
	//output.Pozycja.x+=0.5;	

	//output.Kolor=float4(1,0,0,1);
	
	if(KopiujKolorWerteksu) output.Kolor=input.Kolor;
	else output.Kolor=Kolor;

	//if(output.Pozycja.y<0) output.Kolor = float4(1,0,0,1);
	//else output.Kolor = float4(0,1,1,1);

	output.KopiaPozycji=output.Pozycja.xyz;

	return output;
}

float4 PS(VertexShaderInput input) :COLOR
{
	//return input.Kolor;

	//if(input.KopiaPozycji.y<0) return float4(1,0,0,1);
	//else return float4(1,1,1,1);
	float a = sin(input.KopiaPozycji.x/okres+faza)*amplituda;
	return (input.KopiaPozycji.y<a)?float4(1,0,0,1):float4(1,1,1,1);
}

Technique technika
{
	Pass przebieg
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}






















/*
struct Dane_Pozycja
{
		float4 Pozycja   : POSITION0;		
};
struct Dane_PozycjaKolor
{
		float4 Pozycja   : POSITION0;
		float4 Kolor     : COLOR0;
};
struct Dane_Kolor
{
		float4 Kolor : COLOR0;
};

Dane_PozycjaKolor VS(Dane_PozycjaKolor input)
{		
		Dane_PozycjaKolor output;
		output.Pozycja = mul(input.Pozycja,WorldViewProjection);
		if (KopiujKolorWerteksu) output.Kolor = input.Kolor;
		else output.Kolor = Kolor;				
		return output;
}

Dane_Kolor PS(Dane_PozycjaKolor input)
{
		Dane_Kolor output;
		output.Kolor = input.Kolor;				
		return output;
}

Technique technika
{
		Pass przebieg0
		{
			VertexShader = compile vs_2_0 VS();
			PixelShader  = compile ps_2_0 PS();
		}
}
*/